@extends('layout.app')

@section('content')


   <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table id="dataTable" class="table table-bordered ">
                <thead>
                    <tr>
                        <th>
                            ID
                        </th>
                        <th>
                            Requisition No.
                        </th>
                        <th>
                            Branch
                        </th>
                        <th>
                            Status
                        </th>
                        <th>
                            Create Date
                        </th>
                        <th>
                            Location
                        </th>
                        <th>
                            Purposes
                        </th>
                        <th>
                            Recommendations
                        </th>
                        <th>
                            Remarks
                        </th>
                        <th>Employee Name</th>
                        <th>Submited By </th>
                        <th>
                            Submitted File
                        </th>
                        <th></th>
                    </tr>
                </thead>

                <tbody>


                    @foreach ($list as $r)
                            <tr>
                            <td class="text-center">
                                {{ $r->id }}
                            </td>

                            <td class="text-center">
                                {{ $r->requisition_number}}
                            </td>

                            <td class="text-center">
                                {{ $r->branchName}}
                            </td>

                            <td class="text-center">
                                {{ $r->status }}
                            </td>

                            <td class="text-center">
                               {{ date('d-M-Y H:i:s A', strtotime($r->created_at)) }}
                            </td>

                            <td class="text-center">
                                {{ $r->location }}
                            </td>

                            <td class="text-center">
                                {{ $r->purposes }}
                            </td>

                            <td class="text-center">
                                {{ $r->recommendation }}
                            </td>

                            <td class="text-center">
                                {{ $r->remark}}
                            </td>

                            <td class="text-center">
                                {{ $r->name}}
                            </td>

                            <td class="text-center">
                                {{ $r->author}}
                            </td>

                            <td class="text-center ">

                             <?php
                                $file = true;
                                $extension = '';
                                $imageFileExtens = ['jpeg', 'png', 'jpg', 'webp'];

                                if (!empty($r->auth_file)) {
                                    $extension = pathinfo($r->auth_file, PATHINFO_EXTENSION);
                                } else {
                                    $file = false;
                                }
                            ?>


                            @if($file)
                                @if($extension === 'pdf')
                                   @php
                                        $isS3 = checkSettings('store_image_to_s3') === 'enable';
                                        $pdfUrl = $isS3
                                            ? $r->auth_file
                                            : (!empty($r->auth_file) ? asset('storage/authFile/' . $r->auth_file) : null);
                                    @endphp


                                @if($pdfUrl)
                                    <iframe src="{{ $pdfUrl }}" width="100%" height="100px" style="border: none;"></iframe>

                                    <a href="{{ $pdfUrl }}"
                                    class="btn btn-warning mt-2"
                                    download
                                    target="_blank">
                                        Download PDF
                                    </a>
                                @else
                                    <h6 class="lead">PDF Not Provided</h6>
                                @endif

                                @elseif(in_array(strtolower($extension), $imageFileExtens))

                                   @php
                                        $isS3 = checkSettings('store_image_to_s3') === 'enable';
                                        $imgUrl = $isS3
                                            ? $r->auth_file // assume full URL from S3
                                            : (!empty($r->auth_file) ? asset('storage/requsition/' . $r->auth_file) : null);
                                    @endphp

                                   @if($imgUrl)
                                        <img src="{{ $imgUrl }}" alt="Auth Image" class="img-fluid" style="max-width: 100%; height: 100px;" />
                                    @else
                                        <h6 class="lead">Image Not Provided</h6>
                                    @endif

                                @else
                                    <h6 class="lead">Unsupported File Type</h6>
                                @endif
                            @else
                                <h6 class="lead">File Not Provided</h6>
                            @endif

                            </td>
                            <td>
                                @can('requisition_show')
                                    <a href="{{ route('requisition.show', $r->id) }}">
                                        <button class="btn btn-primary "> Show</button>
                                    </a>
                                @endcan
                            </td>
                        </tr>


                    @endforeach

                </tbody>
                <!-- More items... -->
                {{-- {{ $list->links() }} --}}
            </table>
            </div>


        </div>
    </div>

@endsection
