<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BandPurchaseItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'bandPurchaseId',
        'service_id',
        'quantity',
        'rate',
        'vat',
        'from_date',
        'to_date',
        'status',
        'line_total'
    ];

    public function service()
    {
        return $this->belongsTo(BandService::class, 'service_id', 'id');
    }
}
