<div class="row">
    <div class="col-12">
        <div class="card shadow-sm">
            <div class="card-header bg-white py-3">
                <div class="row">
                    <div class="col-6">
                        <h4 class="card-title m-0 font-weight-bold text-primary">New Line Request</h4>
                    </div>
                    <div class="col-6">
                        <h5 class="text-right">Total: {{ $lists->count() }}</h5>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover" id="dataTable">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Father Name</th>
                                <th>Mother Name</th>
                                <th>POP</th>
                                <th>Package</th>
                                <th>OTC</th>
                                <th>Fiber Meter</th>
                                <th>Latitude</th>
                                <th>Longitude</th>
                                <th>Phone</th>
                                <th>Address</th>
                                <th>Status</th>
                                <th>Remarks</th>
                                <th>Created By</th>
                                <th>Created At</th>
                                <th width="100"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($lists as $list)
                                <tr>
                                    <td>{{ $list->id }}</td>
                                    <td>{{ $list->name }}</td>
                                    <td>{{ $list->father_name }}</td>
                                    <td>{{ $list->mother_name }}</td>
                                    <td>{{ $list->pop->popname }}</td>
                                    @if ($list->pop->subreseller == 'yes')
                                        <td>{{ $list->subPackage ? $list->subPackage->name : 'N/A' }}</td>
                                    @else
                                        <td>{{ $list->package->package_name }}</td>
                                    @endif
                                    <td>{{ $list->otc }}</td>
                                    <td>{{ $list->fiver_miter }}</td>
                                    <td>{{ $list->lat }}</td>
                                    <td>{{ $list->long }}</td>
                                    <td>{{ $list->phone }}</td>
                                    <td>{{ $list->address }}</td>
                                    <td>{{ $list->status }}</td>
                                    <td>{{ $list->remarks }}</td>
                                    <td>{{ $list->user->name }}</td>
                                    <td>{{ $list->created_at }}</td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-sm btn-secondary dropdown-toggle" type="button" id="actionDropdown{{ $list->id }}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Action
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionDropdown{{ $list->id }}">
                                                @can('new-line-request-status')
                                                    <button type="button" class="dropdown-item open-status-modal" data-id="{{ $list->id }}" data-status="{{ $list->status }}">
                                                        Status
                                                    </button>
                                                @endcan
                                                <a class="dropdown-item" href="{{ route('new-line-request.edit', $list->id) }}">Edit</a>
                                                @can('new-line-request-status')
                                                    <button type="button" class="dropdown-item open-remark-modal" data-id="{{ $list->id }}" data-remarks="{{ $list->remarks }}">
                                                        Remark
                                                    </button>
                                                @endcan
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="statusModal" tabindex="-1" aria-labelledby="statusModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="statusModalLabel">Update Status</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="statusForm" action="#" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="form-group">
                        <label for="statusSelect">Status</label>
                        <select id="statusSelect" name="status" class="form-control">
                            <option value="pending" selected>Pending</option>
                            <option value="approved">Approved</option>
                            <option value="cancelled">Cancelled</option>
                            <option value="done">Done</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="remarkModal" tabindex="-1" aria-labelledby="remarkModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="remarkModalLabel">Update Remark</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="remarkForm" action="#" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="form-group">
                        <label for="remarkTextarea">Remark</label>
                        <textarea id="remarkTextarea" name="remarks" class="form-control" rows="4"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>


