<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BkashPaymentResellerReport extends Model
{
    use HasFactory;

    public function reseller()
    {
        return $this->hasOne(Reseller::class, 'id', 'reseller_id');
    }

    public function pop()
    {
        return $this->belongsTo(Pop::class, 'pop_id');
    }

    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }

    static function list()
    {
        if (auth()->user()->hasRole(['Reseller Admin', 'Reseller', 'Sub Reseller'])){
            $list = BkashPaymentResellerReport::with(['reseller', 'pop', 'client'])
                ->whereIn('pop_id', userPops())
                ->orderBy('id', 'desc')
                ->get();
        }else{
            $list = BkashPaymentResellerReport::with(['reseller', 'pop', 'client'])
                    ->orderBy('id', 'desc')
                    ->get();
        }

        return $list;
    }

}
