<?php

namespace App\Http\Controllers;

use App\Classes\Accounting\Accounting;
use App\Models\Nas;
use App\Models\Pop;
use App\Models\Client;
use App\Models\SessionTrack;
use App\Services\ClientDisconnectService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Brian2694\Toastr\Facades\Toastr;
use GrahamCampbell\ResultType\Success;

class SessionRefreshController extends Controller
{

    public function refreshSession($userId)
    {

        $accounting = new Accounting();
        $accounting->deleteSingleUserFromRadAcct($userId);

        return redirect()->route('onlineCustomer')->with('success_message', 'Session Refreshed');
    }


    public function refresh_session($reseller = '')
    {
        SessionRefreshController::autoSessionDelete();
        return redirect()->route('dashboard')->with('success_message', 'Session Cleared');
    }



    static function userDisconnectProcess($userId)
    {

        $accounting = new Accounting();
        $accounting->singleUserDisconnect($userId);
        $accounting->setAcctStopTimeNow($userId);
    }



    static function online()
    {

        $accounting = new Accounting();

        return $accounting->totalOnlineUser();

    }

    static function duplicateDisconnect()
    {

        $accounting = new Accounting();

        $null_ip_users = $accounting->nullIpLogsUserNames();



        $active = $accounting->allDuplicateOnlineUser();

        if (!empty($active)) {
            echo 'start duplicate disconnect';
            foreach ($active as $l) {
                SessionRefreshController::userDisconnectProcess($l->username);
            }
           
        }






        if (!empty($null_ip_users)) {
            $accounting->setAcctStopTimeNowToAListOfCustomer($null_ip_users);

          
            foreach ($null_ip_users as $userId) {
                SessionRefreshController::userDisconnectProcess($userId);
            }
           
        }
    }

    static function sessionRefreshIntervalNull()
    {

        $accounting = new Accounting();

        $list = $accounting->allOnlineIdNotUpdateOverFiveMinute();
        $accounting->setAcctStopTimeNowToAListOfCustomer($list);
        $accounting->resetAcctStopTimeWithHibruLogic();
    }


    static function sessionRefreshIntervalDiff()
    {

        $accounting = new Accounting();

        $list = $accounting->allFiveMinuteOverSecondLogic();

        $accounting->setAcctStopTimeNowToAListOfCustomer($list);



    }

    static function allUser()
    {
        $allClientsUserId = DB::table('clients')->pluck('userid')->all();

        foreach ($allClientsUserId as $userId) {
            SessionRefreshController::userDisconnectProcess($userId);
        }
    }

    static function deleteSessionIfStartTimeIsInFuture()
    {

        $accounting = new Accounting();
        $accounting->deleteSessionIfStartTimeIsInFuture();

    }

    static function deleteOnlineCustomer(){

        $new_accounting = new Accounting();
        $new_accounting->setAllOnlineUserOfflineToSoftware();
        Toastr::success('All online customer has been deleted', 'Success');
        return redirect()->back();
    }



    //SessionRefreshController::allUser();

    static function autoSessionDelete()
    {
        //  SessionRefreshController::duplicateDisconnect();

        SessionRefreshController::deleteSessionIfStartTimeIsInFuture();
        SessionRefreshController::sessionRefreshIntervalNull();
        SessionRefreshController::sessionRefreshIntervalDiff();




        SessionTrack::where('id', 1)->increment('count', 1);
    }

    public function singleIdDeleteFromRadacctTable(Request $request)
    {
        try{
            $accounting = new Accounting();
            $accounting->deleteSingleUserFromRadAcct($request->userid);

            return ['status' => 'successfully deleted'];
        }catch(\Exception $e){
            return ['status' => 'can not delete'];
        }

    }
}
