<table id="dataTable" class="table table-bordered table-striped table-condensed">
    <thead class="bg-gray-50">
        <tr class="bg-black text-center">
            <th>ID</th>
            <th>Token</th>
            <th>Token Code</th>
            <th>Date</th>
            <th>Description</th>
            <th>Username</th>
            <th>Address</th>
            <th>Contact</th>
            <th>Created By</th>
            <th>Created By Client</th>
            <th>Assign To</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($list as $r)
            <tr>
                <td>{{ $r->id }}</td>
                <td>{{ $r->token }}</td>
                <td>{{ $r->Code->tokenCode ?? '' }}</td>
                <td>{{ $r->created_at }}</td>
                <td>{{ $r->description }}</td>
                <td>{{ $r->clients->userid ?? '' }}</td>
                <td style="width:350px;">
                    <p style="font-size:14px;">
                        @if (!empty($r->clients->clientsinfo->flat_no))
                            Flat No: {{ $r->clients->clientsinfo->flat_no ?? '' }},
                        @endif
                        @if (!empty($r->clients->clientsinfo->building_name))
                            Building Name: {{ $r->clients->clientsinfo->building_name ?? '' }},<br>
                        @endif
                        @if (!empty($r->clients->clientsinfo->road_no))
                            Road No: {{ $r->clients->clientsinfo->road_no ?? '' }},<br>
                        @endif
                        @if (!empty($r->clients->clientsinfo->block_sector))
                            Block/Sector: {{ $r->clients->clientsinfo->block_sector ?? '' }},
                        @endif
                        @if (!empty($r->clients->clientsinfo->area))
                            Area : {{ $r->clients->clientsinfo->area ?? '' }}, <br>
                        @endif
                        @if (!empty($r->clients->clientsinfo->box))
                            Box : {{ $r->clients->clientsinfo->box ?? '' }}
                        @endif
                    </p>
                </td>
                <td>{{ $r->reporterContact }}</td>
                <td>{{ $r->creator->name ?? '' }}</td>
                <td>{{ $r->createByClient }}</td>
                <td>
                    <form action="{{ route('assignStore', $r->id) }}" method="POST" name="editForm">
                        @csrf
                        <input type="hidden" name="assignUserId" value="{{ Auth::user()->id }}">
                        <div class="d-flex justify-content-between">
                            <select class="select2 mr-1 pr-2 form-control-sm" name="assignToken">
                                <option value="">Select</option>
                                @forelse ($employees as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }} -
                                        {{ $item->user_id }}</option>
                                @empty
                                @endforelse
                            </select>
                            <button type="submit" class="btn btn-primary float-right btn-sm">
                                Assign
                            </button>
                        </div>
                    </form>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
