@extends('layout.app')
@section('content')
    <div class="card">

        <div class="card-body">
            <form action="{{ route('userRoleUpdate', $user->id) }}" method="POST">
                @method('PUT')
                @csrf

                <h2 class="page-header">User Name : {{ $user->name }}</h2>

                <table class="table table-bordered">
                    <tr>
                        <th>ID</th>
                        <th>Role Name</th>
                        <th></th>
                    </tr>
                    @foreach ($roles as $role)
                        <tr>
                            @if (auth()->user()->email == 'admin@gmail.com')
                                @if ($role->name != 'Admin' && $role->name != 'Software Admin')
                                    <td>{{ $role->id }}</td>
                                    <td>{{ $role->name }}</td>
                                    <td>
                                        <input type="hidden" name="name" value="{{ $user->name }}">
                                        <input type="hidden" name="id" value="{{ $user->id }}">
                                        <div class="form-group">
                                            <div class="custom-control custom-switch">
                                                <input class="custom-control-input" id="role{{ $role->id }}"
                                                    name="role[]" type="checkbox" value="{{ $role->id }}"
                                                    @if ($user->hasRole($role->name)) {{ 'checked' }} @endif>
                                                <label class="custom-control-label" for="role{{ $role->id }}"></label>
                                            </div>
                                        </div>
                                    </td>
                                @endif
                            @else
                                <td>{{ $role->id }}</td>
                                <td>{{ $role->name }}</td>
                                <td>
                                    <input type="hidden" name="name" value="{{ $user->name }}">
                                    <input type="hidden" name="id" value="{{ $user->id }}">
                                    <div class="form-group">
                                        <div class="custom-control custom-switch">
                                            {{-- <input type="checkbox" class="custom-control-input" id="customSwitch1"> --}}
                                            <input class="custom-control-input" id="role{{ $role->id }}" name="role[]"
                                                type="checkbox" value="{{ $role->id }}"
                                                @if ($user->hasRole($role->name)) {{ 'checked' }} @endif>
                                            <label class="custom-control-label" for="role{{ $role->id }}"></label>
                                        </div>
                                    </div>
                                </td>
                            @endif
                        </tr>
                    @endforeach
                </table>

                <div class="form-group">
                    <a href="{{ route('user.index') }}" class="btn btn-default"><i class="fa fa-arrow-left"></i> Back</a>
                    <input type="submit" class="btn btn-primary float-right" value="Assign Role">
                </div>

                <div class="p-5 text-right">
                </div>
            </form>
        </div>
    </div>
@endsection
