<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIdsToCustomerSummaryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('client_summaries', function (Blueprint $table) {
            $table->longText('active_ides')->nullable();
            $table->longText('expire_ides')->nullable();
            $table->longText('disable_ides')->nullable();
            $table->longText('de_active_ides')->nullable();
            $table->longText('close_ides')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('client_summaries', function (Blueprint $table) {
            $table->dropColumn('active_ides');
            $table->dropColumn('expire_ides');
            $table->dropColumn('disable_ides');
            $table->dropColumn('de_active_ides');
            $table->dropColumn('close_ides');
        });
    }
}
