@extends('layout.app')

@section('content')
    @php
        $customer_bill_payment = json_decode($settings[0]->email_body);
        $customer_bill_generated = json_decode($settings[1]->email_body);
        // dd($customer_bill_payment->sendemail);
    @endphp
    <div class="card">
        <div class="card-body">

            <div class="card card-secondary card-tabs">
                <div class="card-header p-0 pt-1">
                    <ul class="nav nav-tabs" id="custom-tabs-one-tab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="custom-tabs-one-bill-payment" data-toggle="pill"
                                href="#custom-tabs-one-bill-payment-email" role="tab"
                                aria-controls="custom-tabs-one-bill-payment-email" aria-selected="true">Bill Payment</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="custom-tabs-one-bill-generated" data-toggle="pill"
                                href="#custom-tabs-one-bill-generated-email" role="tab"
                                aria-controls="custom-tabs-one-bill-generated-email" aria-selected="false">Bill
                                Generated</a>
                        </li>


                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content" id="custom-tabs-one-tabContent">
                        <div class="tab-pane fade show active" id="custom-tabs-one-bill-payment-email" role="tabpanel"
                            aria-labelledby="custom-tabs-one-bill-payment">
                            <div class="container col-md-12">
                                <table>
                                    <tr>
                                        <td style="width: 300px;text-align: right">From </td>
                                        <td><strong> Bill Payment</strong> </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 300px;text-align: right;">Send Email?</td>
                                        <td style="vertical-align: top">
                                            <div class="row">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio"
                                                        name="customer_bill_payment_send_email"
                                                        id="customer_bill_payment_send_email_yes"
                                                        @if ($customer_bill_payment->sendemail == 'Yes') checked @endif value="Yes">
                                                    <label class="form-check-label" for="yes">
                                                        Yes
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio"
                                                        name="customer_bill_payment_send_email"
                                                        id="customer_bill_payment_send_email_no"
                                                        @if ($customer_bill_payment->sendemail == 'No') checked @endif value="No">
                                                    <label class="form-check-label" for="no">
                                                        No
                                                    </label>
                                                </div>
                                            </div>

                                        </td>
                                    </tr>


                                    <tr>
                                        <td style="width: 300px;text-align: right;vertical-align: top">Email Massage* <br>
                                            <span style="color:#FF0000;font-size:12px">Type Text here</span>
                                        </td>
                                        <td style="width: 600px;">

                                            <textarea style="font-size:12px" class="form-control summernote" id="customer_bill_payment_send_email_body"
                                                spellcheck="false" rows="10">{{ $customer_bill_payment->email_body }}</textarea>

                                        </td>
                                        <td style="width: 300px">
                                            <textarea class="form-control" id="customer_bill_payment_send_email_field" style="font-size:12px" spellcheck="false"
                                                rows="10" readonly>{c_id}&#10;{c_username}&#10;{c_name}&#10;{PaymentAmount}&#10;{PaymentDiscount}&#10;{PaymentMethod}&#10;{TotalDue}&#10;{MoneyreciptNo}&#10;{TrxId}&#10;{payment_description}&#10;{company_name}&#10;{company_cell}</textarea>

                                        </td>
                                    </tr>
                                </table>
                                <div class="row mt-2">
                                    <div class="col-md-12">
                                        <div class="float-right">
                                            <button type="submit" id="customer_bill_payment_send_email_submit_btn"
                                                class="btn btn-default bg-primary float-right">Submit</button>
                                        </div>
                                        <div class="float-right">
                                            <button type="submit" id="customer_bill_payment_send_email_reset_btn"
                                                class="btn btn-default float-right mr-2">Reset</button>
                                        </div>
                                    </div>


                                </div>


                            </div>
                            {{-- <x-emailcontent
                                tamplatename="Bill Payment"
                                body={{$customer_bill_payment->email_body }}
                                field="{c_id}&#10;{c_username}&#10;{c_name}&#10;{PaymentAmount}&#10;{PaymentDiscount}&#10;{PaymentMethod}&#10;{TotalDue}&#10;{MoneyreciptNo}&#10;{TrxId}&#10;{payment_description}&#10;{company_name}&#10;{company_cell}"
                                submit="customer_bill_payment_send_email_submit_btn"
                                reset="customer_bill_payment_send_email_reset_btn"
                            /> --}}
                        </div>

                        <div class="tab-pane fade show " id="custom-tabs-one-bill-generated-email" role="tabpanel"
                            aria-labelledby="custom-tabs-one-bill-generated">
                            <div class="container col-md-12">
                                <table>
                                    <tr>
                                        <td style="width: 300px;text-align: right">From </td>
                                        <td><strong> Bill Generated</strong> </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 300px;text-align: right;">Send Email?</td>
                                        <td style="vertical-align: top">
                                            <div class="row">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio"
                                                        name="customer_bill_generated_send_email"
                                                        id="customer_bill_generated_send_email_yes"
                                                        @if ($customer_bill_generated->sendemail == 'Yes') checked @endif value="Yes">
                                                    <label class="form-check-label" for="yes">
                                                        Yes
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio"
                                                        name="customer_bill_generated_send_email"
                                                        id="customer_bill_generated_send_email_no"
                                                        @if ($customer_bill_generated->sendemail == 'No') checked @endif value="No">
                                                    <label class="form-check-label" for="no">
                                                        No
                                                    </label>
                                                </div>
                                            </div>

                                        </td>
                                    </tr>

                                    @php
                                        
                                    @endphp
                                    <tr>
                                        <td style="width: 300px;text-align: right;vertical-align: top">Email Massage* <br>
                                            <span style="color:#FF0000;font-size:12px">Type Text here</span>
                                        </td>
                                        <td style="width: 600px;">

                                            <textarea style="font-size:12px" class="form-control summernote" id="customer_bill_generated_send_email_body"
                                                spellcheck="false" rows="10">{{ $customer_bill_generated->email_body }}</textarea>

                                        </td>
                                        <td style="width: 300px">
                                            <textarea class="form-control" id="customer_bill_generated_send_email_feild" style="font-size:12px"
                                                spellcheck="false" rows="10" readonly>{c_id}&#10;{c_username}&#10;{c_name}&#10;{TotalDue}&#10;{ThisMonth}&#10;{billing_deadline}&#10;{MonthBillAmount}&#10;{MonthDiscountAmount}&#10;{company_name}&#10;{company_cell}&#10;{bill_type}&#10;{bill_generate_month}</textarea>

                                        </td>
                                    </tr>
                                </table>
                                <div class="row mt-2">
                                    <div class="col-md-12">
                                        <div class="float-right">
                                            <button type="submit" id="customer_bill_generated_eamil_submit_btn"
                                                class="btn btn-default bg-primary float-right">Submit</button>
                                        </div>
                                        <div class="float-right">
                                            <button type="submit" id="customer_bill_generated_eamil_reset_btn"
                                                class="btn btn-default float-right mr-2">Reset</button>
                                        </div>
                                    </div>


                                </div>


                            </div>
                        </div>

                    </div>
                </div>

            </div>

        </div>


    </div>
    <style>
        th,
        td {
            padding-top: 5px;
            padding-bottom: 5px;
            padding-left: 10px;
            padding-right: 0px;
        }
    </style>
@endsection

@section('ajax')
    <link href="{{ asset('/') }}plugins/summernote/summernote-bs4.css" rel="stylesheet">
    <script src="{{ asset('/') }}plugins/summernote/summernote-bs4.js"></script>
    <script>
        $(document).ready(function() {

            //summernote
            $('.summernote').summernote();

            function save_email_template(email_body_string, email_type) {

                $.ajax({
                    type: "POST",
                    url: "{{ route('email-tempalte-save') }}",
                    data: {
                        email_body: email_body_string,
                        email_type: email_type
                    },
                    success: function(data) {
                        if (data == 1) {
                            toastr.success('Email Template Update Successfully');
                        } else {
                            toastr.error('Email Template Not Saved');
                        }
                    }
                })


            }

            $('#customer_bill_payment_send_email_submit_btn').click(function() {

                let email_body = $('#customer_bill_payment_send_email_body').val();
                let sendeamil = $("input[name='customer_bill_payment_send_email']:checked").val();

                let obj = new Object();
                obj.email_body = email_body;
                obj.sendemail = sendeamil;

                var string = JSON.stringify(obj);
                save_email_template(string, 'customer_payment_eamil');
            });

            $('#customer_bill_payment_send_email_reset_btn').click(function() {
                let email_body =
                    "প্রিয় গ্রাহক ({c_name}),\nআপনার বিল সঠিক ভাবে সংগৃহিত হয়েছে। সংগৃহিত টাকার পরিমান- TK {PaymentAmount} | যেকোনো তথ্যের জন্য যোগাযোগ {company_cell} | {company_name} এর সাথে থাকার জন্য ধন্যবাদ।";
                let sendemail = "No";

                let obj = new Object();
                obj.email_body = email_body;
                obj.sendemail = sendemail;

                let string = JSON.stringify(obj);

                $('#customer_bill_payment_send_email_body').val(email_body);
                $('#customer_bill_payment_send_email_no').prop('checked', true);
                save_email_template(string, 'customer_payment_eamil');
            });

            $('#customer_bill_generated_eamil_submit_btn').click(function() {

                let email_body = $('#customer_bill_generated_send_email_body').val();
                let sendeamil = $("input[name='customer_bill_generated_send_email']:checked").val();

                let obj = new Object();
                obj.email_body = email_body;
                obj.sendemail = sendeamil;

                var string = JSON.stringify(obj);
                save_email_template(string, 'bill_generate_eamil');
            });

            $('#customer_bill_generated_eamil_reset_btn').click(function() {
                let email_body =
                    "Dear {c_name}\n {MonthBillAmount} TK Bill generate for {bill_type}\n\nPlease Pay Before: 05 {ThisMonth}\n\n{company_name}\n{company_cell}";
                let sendemail = "No";

                let obj = new Object();
                obj.email_body = email_body;
                obj.sendemail = sendemail;

                let string = JSON.stringify(obj);

                $('#customer_bill_payment_send_email_body').val(email_body);
                $('#customer_bill_generated_send_email_no').prop('checked', true);
                save_email_template(string, 'bill_generate_eamil');
            });



        });
    </script>
@endsection
