@extends('layout.app')
@section('content')
    <form action="{{ route('roles.update', $role->id) }}" method="POST">
        @method('put') @csrf
        <div class="card">
            <div class="card-body">

                <div class="form-group col-md-4">
                    <label for="name" class="block text-sm font-medium text-gray-700">
                        Role Name*
                    </label>

                    <input type="hidden" value="{{ $role->id }}">
                    <input type="text" name="name" id="name" value="{{ $role->name }}" class="form-control"
                        placeholder="Role Name" autocomplete="off">
                    @error('name')
                        <div class="text-red-500 mt-2 text-sm">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="form-group col-md-6">

                    <a href="{{ route('roles.index') }}" class="btn btn-default"> <i class="fa fa-arrow-left"></i> Back to
                        Role List</a>

                    <button type="submit" class="btn btn-primary float-right">
                        Update
                    </button>
                </div>
            </div>
        </div>
    </form>
@endsection
