@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-body">



            <div class="label label-info">
                <h4 class="p-2 inline-block float-left">Account Log of {{ $clientsinfo->clients_name ?? '' }}</h4>

            </div>

            @can('reseller-client-extra-bill-add')
                @include('clients.resellerClientPayment.modal.resellerAddBill')
            @endcan
            @can('reseller-client-payment-add')
                @include('clients.resellerClientPayment.modal.resellerPayment')
            @endcan



            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr style="background:#78716C !important; color:white;">
                            <th class="col-md-1">ID</th>
                            <th class="col-md-1">Name</th>
                            <th class="col-md-1">User ID</th>
                            <th class="col-md-1">Address</th>
                            <th class="col-md-1">Mobile No</th>
                            <th class="col-md-1">Speed</th>
                            <th class="col-md-1">Taka</th>
                            <th class="col-md-1">C. Date</th>
                            <th class="col-md-1">E. Date</th>
                            <th class="col-md-1">Pop/Zone</th>
                            <th class="col-md-1">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>
                                @php(printf('CID%04d', $client->id))
                            </td>
                            <td>{{ $client->clients_name }}</td>
                            <td>{{ $client->userid }}</td>
                            <td>Flat No: {{ $client->flat_no ?? '' }} ,
                                Building Name: {{ $client->building_name ?? '' }} ,
                                Road No: {{ $client->road_no ?? '' }} ,
                                Block/Sector: {{ $client->block_sector ?? '' }} ,
                                Area : {{ $client->area ?? '' }},
                                Box : {{ $client->box ?? '' }}
                            </td>
                            <td>{{ $client->contact_no }}</td>
                            <td>{{ $client->package_name }}</td>

                            <td>Rate: {{ $client->package_rate }}
                                @if (checkSettings('parmanent_discount') == 'enable')
                                    <hr>
                                    P Dis: {{ $client->parmanent_discount }}
                                @endif
                            </td>
                            <td>{{ date('d-M-Y', strtotime($client->created_at)) }}</td>
                            <td id="cExpDate">{{ date('d-M-Y', strtotime($client->expire_date)) }}</td>
                            <td class="text-center">{{ $client->popname }}</td>

                            <td>


                                <form action="{{ route('billGenerateResellerClient') }}" method="post">
                                    @csrf
                                    <input name="id" type="hidden" value="{{ $client->id }}">
                                    <button onclick="return confirm('Are you sure you want to Generate Bill?');"
                                        class="btn btn-info btn-sm" type="submit">Generate Monthly Bill</button>
                                </form>


                                <hr>

                                @can('mac-customer_edit')
                                    <a href="{{ route('clients.edit', $client->id) }}"
                                        class="btn btn-success btn-xs btn-block">Edit</a>
                                @endcan


                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <div class="card">
        <div class="card-header">
            <h2 class="text-center">Payment Information</h2>
        </div>
        <div class="card-body table-responsive">
            <table class="table table-bordered">
                <tr>
                    <td class="text-bold">Service Amount</td>
                    <td class="text-bold">Total Bill Amount</td>
                    <td class="text-bold">Total Paid Amount</td>
                    <td class="text-bold">Total Discount Amount</td>
                    <td class="text-bold">Current Balance</td>


                </tr>
                <tr>
                    <td>
                        <p class="alert alert-success">{{ getResellerClientPaymentAmount($client) }}</p>
                    </td>
                    <td>
                        <p class="alert alert-success">{{ $client->resellerClientBillGenerates->sum('amount') }}</p>
                    </td>
                    <td>
                        <p class="alert alert-success">{{ $client->resellerClientBillPayments->sum('paid_amount') }}</p>
                    </td>
                    <td>
                        <p class="alert alert-success">{{ $client->resellerClientBillPayments->sum('discount_amount') }}
                        </p>
                    </td>
                    <td>
                        @php($resellerClientBalance = isset($client->customer_account_balance_reseller) ? $client->customer_account_balance_reseller : 0)

                        @if ($resellerClientBalance >= 0)
                            <p class="alert alert-danger"> Due: {{ number_format($resellerClientBalance, 2) }}</p>
                        @elseif ($resellerClientBalance < 0)
                            <p class="alert alert-success"> Advance: {{ number_format(abs($resellerClientBalance), 2) }}
                            </p>
                        @endif

                    </td>



                </tr>
            </table>
        </div>
    </div>



    <div class="card">

        <div class="row">




            <div class="col-md-7" id="paymentHistoryTable">
                <h2 class="header text-center">Bill Payments</h2>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Description</th>
                                <th>Amount</th>
                                <th>Discount</th>

                            </tr>
                            @foreach ($client->resellerClientBillPayments as $payment)
                                <tr class="{{ $payment->deleted_at ? 'opacity-50' : '' }}">
                                    <td> @can('reseller-client-payment-delete')
                                        <form action="{{ route('reseller-client-payment-delete', $payment->id) }}"
                                            method="POST" style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm"
                                                onclick="return confirm('Are you sure you want to delete this payment?')">
                                                Delete
                                            </button>
                                        </form>
                                    @endcan{{ $payment->id }}</td>
                                    <td>{{ $payment->description ?? '' }} payment by {{ $payment->paymentBy->name }} at
                                        {{ $payment->created_at }}</td>
                                    <td>{{ $payment->paid_amount }}</td>
                                    <td>{{ $payment->discount_amount }}</td>

                                </tr>
                            @endforeach
                            <tr class="text-bold">
                                <td colspan="2">Total</td>
                                <td>{{ $client->resellerClientBillPayments->sum('paid_amount') }} TK</td>
                                <td>{{ $client->resellerClientBillPayments->sum('discount_amount') }} TK</td>


                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="col-md-5">
                <h2 class="header text-center">Bill History</h2>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Description</th>
                                <th>Date</th>
                                <th>Amount</th>

                            </tr>
                            @foreach ($client->resellerClientBillGenerates as $bill)
                                <tr class="{{ $bill->deleted_at ? 'opacity-50' : '' }}">
                                    <td>
                                        @can('reseller-client-bill-delete')
                                        <form action="{{ route('reseller-client-bill-delete', $bill->id) }}" method="POST"
                                            style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm"
                                                onclick="return confirm('Are you sure you want to delete this bill?')">
                                                Delete
                                            </button>
                                        </form>
                                    @endcan
                                    {{ $bill->id }}
                                </td>
                                    <td>{{ $bill->description }}</td>
                                    <td>{{ $bill->created_at }}</td>
                                    <td>{{ $bill->amount }}</td>

                                </tr>
                            @endforeach
                            <tr class="text-bold">
                                <td colspan="3">Total</td>
                                <td>{{ $client->resellerClientBillGenerates->sum('amount') }} TK</td>

                            </tr>
                        </thead>
                    </table>
                </div>
            </div>


        </div>

    </div>
@endsection


@section('ajax')
    <style>
        label {
            font-size: 15px !important;
        }
    </style>
    <script>
        $(function() {



        });
    </script>
@endsection
